Slider = class()

function Slider:init(data)
    -- slider geometry
    self.x0 = WIDTH - 20
    self.x1 = self.x0
    self.y0 = HEIGHT*0.7
    self.y1 = HEIGHT*0.1
    self.dy = 0
    self.dyMax = self.y0-self.y1
    -- manage and view the demo tabs
    self.selector = Selector(data)
    self.ratio = (self.y0-self.y1)/(self.selector.h * (#self.selector.list-1))
    self.selector.x = self.x0 - self.selector.w - 50
    self.selector.y = self.y0 - self.selector.h/2
    self.selector.visible = false
    -- a draggable dot to move the slider
    self.dot = Dot{ x=self.x0, y=self.y0+self.dy, r=16}
    self.dotSensor = Sensor{ parent=self.dot, xywhMode=RADIUS, extra=10}
    self.dotSensor:onDrag( function(event) self:drag(event.touch) end )
end

-- set a choice in the selector list
function Slider:setCur(v)
    self.selector:setCur(v)
    self.dy = (v-1) * self.selector.h * self.ratio
    self.selector.y = self.y0 - self.selector.h/2 - self.dy
    self.dot.y = self.y0 - self.dy
end

function Slider:draw()
    -- slider line
    smooth()
    stroke(0)
    strokeWidth(10)
    line(self.x0,self.y0,self.x1,self.y1)
    stroke(200)
    strokeWidth(6)
    line(self.x0,self.y0,self.x1,self.y1)
    -- slider dot
    self.dot:draw()
    self.selector:draw()
end

function Slider:drag(t)
    local s = self.selector
    if t.state == BEGAN then
        s.visible = true
    elseif t.state == MOVING then
        self.dy = self.dy - t.deltaY
        if self.dy < 0 then self.dy =0 end
        if self.dy > self.dyMax then self.dy =self.dyMax end
        s.dy = self.dy/self.ratio
        s.y = self.y0 - s.h/2 - self.dy
        self.dot.y = self.y0 - self.dy
    elseif t.state == ENDED then
        -- when finger released, finalize the value
        s:update_cur()
        s:update_dy()
        s.callback( s.cur , s.list[ s.cur ] )
        s.visible = false
    end
end

function Slider:touched(t)
    self.dotSensor:touched(t)
end
